/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONCraftingBench;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityLastOpenedItemChange;
import minecrafttransportsimulator.packets.instances.PacketPlayerCraftItem;
import minecrafttransportsimulator.packloading.PackMaterialComponent;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.packloading.PackResourceLoader;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.systems.LanguageSystem;

public class GUIPartBench
extends AGUIBase {
    private final AEntityD_Definable<?> entity;
    private final JSONCraftingBench definition;
    private final IWrapperPlayer player;
    private GUIComponentButton prevPackButton;
    private GUIComponentButton nextPackButton;
    private GUIComponentLabel packName;
    private GUIComponentButton prevPartButton;
    private GUIComponentButton nextPartButton;
    private GUIComponentLabel partName;
    private GUIComponentButton prevColorButton;
    private GUIComponentButton nextColorButton;
    private GUIComponentButton nextRecipeButton;
    private GUIComponentLabel partInfo;
    private GUIComponentLabel vehicleInfo;
    private GUIComponentButton vehicleInfoButton;
    private GUIComponentButton vehicleDescriptionButton;
    private GUIComponentButton repairCraftingButton;
    private GUIComponentButton normalCraftingButton;
    private GUIComponentButton confirmButton;
    private final List<GUIComponentItem> craftingItemIcons = new ArrayList<GUIComponentItem>();
    private final List<GUIComponentCutout> craftingItemBackgrounds = new ArrayList<GUIComponentCutout>();
    private List<PackMaterialComponent> materials;
    private GUIComponentItem itemRender;
    private GUIComponent3DModel modelRender;
    private String prevPack;
    private String currentPack;
    private String nextPack;
    private boolean viewingRepair;
    private AItemPack<? extends AJSONItem> prevItem;
    private AItemPack<? extends AJSONItem> currentItem;
    private AItemPack<? extends AJSONItem> nextItem;
    private int recipeIndex;
    private AItemPack<? extends AJSONItem> prevSubItem;
    private AItemPack<? extends AJSONItem> nextSubItem;
    boolean displayVehicleInfo = false;

    public GUIPartBench(AEntityD_Definable<?> entity, JSONCraftingBench definition) {
        this.entity = entity;
        this.definition = definition;
        this.player = InterfaceManager.clientInterface.getClientPlayer();
        if (entity.lastOpenedItem != null) {
            this.currentItem = entity.lastOpenedItem;
            this.currentPack = ((AJSONItem)this.currentItem.definition).packID;
        } else {
            for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
                if (!packItem.isBenchValid(definition)) continue;
                this.currentItem = packItem;
                this.currentPack = ((AJSONItem)packItem.definition).packID;
                return;
            }
        }
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.prevPackButton = new GUIComponentButton(this, this.guiLeft + 17, this.guiTop + 11, 20, 20, 40, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentPack = GUIPartBench.this.prevPack;
                GUIPartBench.this.viewingRepair = false;
                GUIPartBench.this.currentItem = null;
                GUIPartBench.this.recipeIndex = 0;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.prevPackButton);
        this.nextPackButton = new GUIComponentButton(this, this.guiLeft + 243, this.guiTop + 11, 20, 20, 60, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentPack = GUIPartBench.this.nextPack;
                GUIPartBench.this.viewingRepair = false;
                GUIPartBench.this.currentItem = null;
                GUIPartBench.this.recipeIndex = 0;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.nextPackButton);
        int centerBetweenButtons = this.prevPackButton.constructedX + this.prevPackButton.width + (this.nextPackButton.constructedX - (this.prevPackButton.constructedX + this.prevPackButton.width)) / 2;
        this.packName = new GUIComponentLabel(centerBetweenButtons, this.guiTop + 16, ColorRGB.WHITE, "", RenderText.TextAlignment.CENTERED, 1.0f);
        this.addComponent(this.packName);
        this.prevPartButton = new GUIComponentButton(this, this.prevPackButton.constructedX, this.prevPackButton.constructedY + this.prevPackButton.height, 20, 20, 40, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentItem = GUIPartBench.this.prevItem;
                GUIPartBench.this.viewingRepair = false;
                GUIPartBench.this.recipeIndex = 0;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.prevPartButton);
        this.nextPartButton = new GUIComponentButton(this, this.nextPackButton.constructedX, this.nextPackButton.constructedY + this.nextPackButton.height, 20, 20, 60, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentItem = GUIPartBench.this.nextItem;
                GUIPartBench.this.viewingRepair = false;
                GUIPartBench.this.recipeIndex = 0;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.nextPartButton);
        this.partName = new GUIComponentLabel(this.packName.constructedX, this.packName.constructedY + this.prevPackButton.height, ColorRGB.WHITE, "", RenderText.TextAlignment.CENTERED, 0.75f);
        this.addComponent(this.partName);
        this.partInfo = new GUIComponentLabel(this.guiLeft + 17, this.guiTop + 60, ColorRGB.WHITE, "", RenderText.TextAlignment.LEFT_ALIGNED, 0.75f, 150);
        this.addComponent(this.partInfo);
        this.vehicleInfo = new GUIComponentLabel(this.guiLeft + 17, this.guiTop + 60, ColorRGB.WHITE, "", RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, 150);
        this.addComponent(this.vehicleInfo);
        this.prevColorButton = new GUIComponentButton(this, this.guiLeft + 175, this.guiTop + 131, 20, 15, 40, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentItem = GUIPartBench.this.prevSubItem;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.prevColorButton);
        this.nextColorButton = new GUIComponentButton(this, this.guiLeft + 245, this.guiTop + 131, 20, 15, 60, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentItem = GUIPartBench.this.nextSubItem;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.nextColorButton);
        this.addComponent(new GUIComponentLabel(this.prevColorButton.constructedX + this.prevColorButton.width + (this.nextColorButton.constructedX - (this.prevColorButton.constructedX + this.prevColorButton.width)) / 2, this.guiTop + 136, ColorRGB.WHITE, LanguageSystem.GUI_PART_BENCH_COLOR.getCurrentValue(), RenderText.TextAlignment.CENTERED, 1.0f).setComponent(this.nextColorButton));
        this.nextRecipeButton = new GUIComponentButton(this, this.guiLeft + 295, this.guiTop + 148, 20, 20, 180, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                if (++GUIPartBench.this.recipeIndex == ((AJSONItem)((GUIPartBench)GUIPartBench.this).currentItem.definition).general.materialLists.size()) {
                    GUIPartBench.this.recipeIndex = 0;
                }
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.nextRecipeButton);
        this.craftingItemIcons.clear();
        this.craftingItemBackgrounds.clear();
        for (int i = 0; i < 14; i = (int)((byte)(i + 1))) {
            GUIComponentItem craftingItem = new GUIComponentItem(this.guiLeft + 276 + 18 * (i / 7), this.guiTop + 20 + 18 * (i % 7), 1.0f);
            GUIComponentCutout itemBackground = new GUIComponentCutout(this, craftingItem.constructedX, craftingItem.constructedY, craftingItem.width, craftingItem.height, 160, 236, 20, 20);
            itemBackground.visible = false;
            this.addComponent(craftingItem);
            this.addComponent(itemBackground);
            this.craftingItemIcons.add(craftingItem);
            this.craftingItemBackgrounds.add(itemBackground);
        }
        this.itemRender = new GUIComponentItem(this.guiLeft + 175, this.guiTop + 56, 5.625f);
        this.addComponent(this.itemRender);
        this.modelRender = new GUIComponent3DModel(this.guiLeft + 220, this.guiTop + 101, 32.0f, true, true, false);
        this.addComponent(this.modelRender);
        this.vehicleInfoButton = new GUIComponentButton(this, this.guiLeft + 147, this.guiTop + 159, 20, 20, 100, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.displayVehicleInfo = true;
            }
        };
        this.addComponent(this.vehicleInfoButton);
        this.vehicleDescriptionButton = new GUIComponentButton(this, this.guiLeft + 147, this.guiTop + 159, 20, 20, 80, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.displayVehicleInfo = false;
            }
        };
        this.addComponent(this.vehicleDescriptionButton);
        this.repairCraftingButton = new GUIComponentButton(this, this.guiLeft + 127, this.guiTop + 159, 20, 20, 120, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.viewingRepair = true;
                GUIPartBench.this.recipeIndex = 0;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.repairCraftingButton);
        this.normalCraftingButton = new GUIComponentButton(this, this.guiLeft + 127, this.guiTop + 159, 20, 20, 140, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.viewingRepair = false;
                GUIPartBench.this.recipeIndex = 0;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.normalCraftingButton);
        this.confirmButton = new GUIComponentButton(this, this.guiLeft + 211, this.guiTop + 156, 20, 20, 20, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                InterfaceManager.packetInterface.sendToServer(new PacketPlayerCraftItem(GUIPartBench.this.entity, GUIPartBench.this.player, GUIPartBench.this.currentItem, GUIPartBench.this.recipeIndex, GUIPartBench.this.viewingRepair));
            }
        };
        this.addComponent(this.confirmButton);
        this.updateNames();
    }

    @Override
    public void setStates() {
        super.setStates();
        this.prevPackButton.enabled = this.prevPack != null;
        this.nextPackButton.enabled = this.nextPack != null;
        this.prevPartButton.enabled = this.prevItem != null;
        this.nextPartButton.enabled = this.nextItem != null;
        this.prevColorButton.visible = this.currentItem instanceof AItemSubTyped;
        this.prevColorButton.enabled = this.prevSubItem != null;
        this.nextColorButton.visible = this.currentItem instanceof AItemSubTyped;
        this.nextColorButton.enabled = this.nextSubItem != null;
        this.nextRecipeButton.enabled = this.materials != null && !this.materials.isEmpty();
        this.vehicleInfoButton.visible = this.currentItem instanceof ItemVehicle && !this.displayVehicleInfo;
        this.vehicleDescriptionButton.visible = this.currentItem instanceof ItemVehicle && this.displayVehicleInfo;
        this.repairCraftingButton.visible = !this.viewingRepair && this.currentItem != null;
        this.repairCraftingButton.enabled = this.repairCraftingButton.visible && this.currentItem.getRepairRecipeCount() > 0;
        this.normalCraftingButton.visible = this.viewingRepair;
        this.partInfo.visible = !this.displayVehicleInfo;
        this.vehicleInfo.visible = this.displayVehicleInfo;
        if (this.materials != null) {
            int materialOffset = 1 + (this.materials.size() - 1) / this.craftingItemIcons.size();
            materialOffset = (int)(System.currentTimeMillis() % (long)(materialOffset * 5000) / 5000L);
            materialOffset *= this.craftingItemIcons.size();
            for (int i = 0; i < this.craftingItemIcons.size(); i = (int)((byte)(i + 1))) {
                int materialIndex = i + materialOffset;
                if (materialIndex < this.materials.size()) {
                    this.craftingItemIcons.get((int)i).stacks = this.materials.get((int)materialIndex).possibleItems;
                    this.craftingItemBackgrounds.get((int)i).visible = !this.player.isCreative() && GUIPartBench.inClockPeriod(20, 10) && this.player.getInventory().hasSpecificMaterial(this.currentItem, this.recipeIndex, i, true, true, this.viewingRepair, true);
                    continue;
                }
                this.craftingItemIcons.get((int)i).stacks = null;
                this.craftingItemBackgrounds.get((int)i).visible = false;
            }
        } else {
            this.craftingItemIcons.forEach(icon -> {
                icon.stacks = null;
            });
        }
        this.confirmButton.enabled = this.currentItem != null && (this.player.isCreative() || this.materials != null && this.player.getInventory().hasMaterials(this.materials));
        int wheelMovement = InterfaceManager.inputInterface.getTrackedMouseWheel();
        if (wheelMovement < 0 && this.nextPartButton.enabled) {
            this.nextPartButton.onClicked(false);
        } else if (wheelMovement > 0 && this.prevPartButton.enabled) {
            this.prevPartButton.onClicked(false);
        }
    }

    @Override
    public int getWidth() {
        return 327;
    }

    @Override
    public int getHeight() {
        return 196;
    }

    @Override
    protected String getTexture() {
        return "mts:textures/guis/crafting.png";
    }

    /*
     * WARNING - void declaration
     */
    private void updateNames() {
        boolean isPartWithBuiltinTexture;
        int i;
        ArrayList<String> packIDs = new ArrayList<String>(PackParser.getAllPackIDs());
        int currentPackIndex = packIDs.indexOf(this.currentPack);
        this.nextPack = null;
        if (currentPackIndex < packIDs.size()) {
            block0: for (i = currentPackIndex + 1; i < packIDs.size() && this.nextPack == null; ++i) {
                for (AItemPack<?> packItem : PackParser.getAllItemsForPack((String)packIDs.get(i), true)) {
                    if (!packItem.isBenchValid(this.definition)) continue;
                    this.nextPack = (String)packIDs.get(i);
                    continue block0;
                }
            }
        }
        this.prevPack = null;
        if (currentPackIndex > 0) {
            block2: for (i = currentPackIndex - 1; i >= 0 && this.prevPack == null; --i) {
                for (AItemPack<?> packItem : PackParser.getAllItemsForPack((String)packIDs.get(i), true)) {
                    if (!packItem.isBenchValid(this.definition)) continue;
                    this.prevPack = (String)packIDs.get(i);
                    continue block2;
                }
            }
        }
        if (this.currentPack == null) {
            return;
        }
        List<AItemPack<?>> packItems = PackParser.getAllItemsForPack(this.currentPack, true);
        int currentItemIndex = packItems.indexOf(this.currentItem);
        if (this.currentItem == null) {
            for (AItemPack aItemPack : packItems) {
                if (this.currentItem != null && (!(this.currentItem.definition instanceof AJSONMultiModelProvider) || this.nextSubItem != null) || !aItemPack.isBenchValid(this.definition)) continue;
                if (this.currentItem == null) {
                    this.currentItem = aItemPack;
                    currentItemIndex = packItems.indexOf(this.currentItem);
                    continue;
                }
                if (!(this.currentItem.definition instanceof AJSONMultiModelProvider) || this.nextSubItem != null || !((AJSONItem)aItemPack.definition).systemName.equals(((AJSONItem)this.currentItem.definition).systemName)) continue;
                this.nextSubItem = aItemPack;
            }
        }
        this.nextItem = null;
        this.nextSubItem = null;
        if (currentItemIndex < packItems.size()) {
            for (int i2 = currentItemIndex + 1; i2 < packItems.size() && this.nextItem == null; ++i2) {
                if (!packItems.get(i2).isBenchValid(this.definition)) continue;
                if (this.currentItem.definition instanceof AJSONMultiModelProvider && ((AJSONItem)packItems.get((int)i2).definition).systemName.equals(((AJSONItem)this.currentItem.definition).systemName)) {
                    if (this.nextSubItem != null) continue;
                    this.nextSubItem = packItems.get(i2);
                    continue;
                }
                this.nextItem = packItems.get(i2);
                break;
            }
        }
        this.prevItem = null;
        this.prevSubItem = null;
        if (currentItemIndex > 0) {
            for (int i3 = currentItemIndex - 1; i3 >= 0 && (this.prevItem == null || this.currentItem.definition instanceof AJSONMultiModelProvider); --i3) {
                if (!packItems.get(i3).isBenchValid(this.definition)) continue;
                if (this.currentItem.definition instanceof AJSONMultiModelProvider) {
                    if (((AJSONItem)packItems.get((int)i3).definition).systemName.equals(((AJSONItem)this.currentItem.definition).systemName)) {
                        if (this.prevSubItem != null) continue;
                        this.prevSubItem = packItems.get(i3);
                        continue;
                    }
                    if (this.prevItem == null) {
                        this.prevItem = packItems.get(i3);
                        continue;
                    }
                    if (!((AJSONItem)packItems.get((int)i3).definition).systemName.equals(((AJSONItem)this.prevItem.definition).systemName)) continue;
                    this.prevItem = packItems.get(i3);
                    continue;
                }
                this.prevItem = packItems.get(i3);
                break;
            }
        }
        this.packName.text = PackParser.getPackConfiguration((String)this.currentPack).packName;
        this.partName.text = this.currentItem.getItemName();
        ArrayList<String> descriptiveLines = new ArrayList<String>();
        this.currentItem.addTooltipLines(descriptiveLines, InterfaceManager.coreInterface.getNewNBTWrapper());
        this.partInfo.text = "";
        for (String line : descriptiveLines) {
            this.partInfo.text = this.partInfo.text + line + "\n";
        }
        if (this.currentItem instanceof ItemVehicle) {
            this.vehicleInfo.text = this.getVehicleInfoText();
        }
        String string = "";
        do {
            void var6_14;
            this.materials = PackMaterialComponent.parseFromJSON(this.currentItem, this.recipeIndex, true, true, this.viewingRepair, true);
            if (this.materials != null) continue;
            if (++this.recipeIndex == (this.viewingRepair ? this.currentItem.getRepairRecipeCount() : ((AJSONItem)this.currentItem.definition).general.materialLists.size())) {
                this.recipeIndex = 0;
            }
            String string2 = (String)var6_14 + PackMaterialComponent.lastErrorMessage + "\n";
            if (this.recipeIndex != 0) continue;
            this.partInfo.text = string2;
            break;
        } while (this.materials == null);
        boolean isPartWithVehicleTexture = this.currentItem instanceof AItemPart && ((AItemPart)this.currentItem).subDefinition.useVehicleTexture;
        boolean bl = isPartWithBuiltinTexture = this.currentItem instanceof AItemPart && ((JSONPart)((AItemPart)this.currentItem).definition).generic.benchTexture != null;
        if (this.currentItem instanceof AItemSubTyped && (!isPartWithVehicleTexture || isPartWithBuiltinTexture)) {
            this.modelRender.modelLocation = ((AJSONMultiModelProvider)((AItemSubTyped)this.currentItem).definition).getModelLocation(((AItemSubTyped)this.currentItem).subDefinition);
            this.modelRender.textureLocation = isPartWithBuiltinTexture ? PackResourceLoader.getPackResource(this.currentItem.definition, PackResourceLoader.ResourceType.PNG, ((JSONPart)((AItemPart)this.currentItem).definition).generic.benchTexture) : ((AJSONMultiModelProvider)((AItemSubTyped)this.currentItem).definition).getTextureLocation(((AItemSubTyped)this.currentItem).subDefinition, 0);
            this.itemRender.stack = null;
            this.modelRender.spin = !(this.currentItem.definition instanceof JSONPoleComponent) || !((JSONPoleComponent)this.currentItem.definition).pole.type.equals((Object)ItemPoleComponent.PoleComponentType.SIGN);
        } else {
            this.itemRender.stack = this.currentItem.getNewStack(null);
            this.modelRender.modelLocation = null;
        }
        InterfaceManager.packetInterface.sendToServer(new PacketEntityLastOpenedItemChange(this.entity, this.currentItem));
    }

    private String getVehicleInfoText() {
        JSONVehicle vehicleDefinition = (JSONVehicle)this.currentItem.definition;
        int controllers = 0;
        int passengers = 0;
        int cargo = 0;
        int mixed = 0;
        float minFuelConsumption = 99.0f;
        float maxFuelConsumption = 0.0f;
        float minWheelSize = 99.0f;
        float maxWheelSize = 0.0f;
        for (JSONPartDefinition part : vehicleDefinition.parts) {
            if (part.isController) {
                ++controllers;
                continue;
            }
            boolean canAcceptSeat = false;
            boolean canAcceptCargo = false;
            if (part.types.contains("seat")) {
                canAcceptSeat = true;
            }
            if (part.types.contains("crate") || part.types.contains("barrel")) {
                canAcceptCargo = true;
            }
            if (canAcceptSeat && !canAcceptCargo) {
                ++passengers;
            } else if (canAcceptCargo && !canAcceptSeat) {
                ++cargo;
            } else if (canAcceptCargo && canAcceptSeat) {
                ++mixed;
            }
            for (String partNameEntry : part.types) {
                if (!partNameEntry.startsWith("engine")) continue;
                minFuelConsumption = Math.min(part.minValue, minFuelConsumption);
                maxFuelConsumption = Math.max(part.maxValue, maxFuelConsumption);
                break;
            }
            if (!part.types.contains("wheel")) continue;
            minWheelSize = Math.min(part.minValue, minWheelSize);
            maxWheelSize = Math.max(part.maxValue, maxWheelSize);
        }
        String totalInformation = "";
        totalInformation = totalInformation + LanguageSystem.GUI_PART_BENCH_WEIGHT.getCurrentValue() + vehicleDefinition.motorized.emptyMass + "\n";
        totalInformation = totalInformation + LanguageSystem.GUI_PART_BENCH_FUEL.getCurrentValue() + vehicleDefinition.motorized.fuelCapacity + "\n";
        totalInformation = totalInformation + LanguageSystem.GUI_PART_BENCH_CONTROLLERS.getCurrentValue() + controllers + "\n";
        totalInformation = totalInformation + LanguageSystem.GUI_PART_BENCH_PASSENGERS.getCurrentValue() + passengers + "\n";
        totalInformation = totalInformation + LanguageSystem.GUI_PART_BENCH_CARGO.getCurrentValue() + cargo + "\n";
        totalInformation = totalInformation + LanguageSystem.GUI_PART_BENCH_MIXED.getCurrentValue() + mixed + "\n";
        if (minFuelConsumption != 99.0f) {
            totalInformation = totalInformation + LanguageSystem.GUI_PART_BENCH_ENGINE.getCurrentValue() + minFuelConsumption + "-" + maxFuelConsumption + "\n";
        }
        if (minWheelSize != 99.0f) {
            totalInformation = totalInformation + LanguageSystem.GUI_PART_BENCH_WHEEL.getCurrentValue() + minWheelSize + "-" + maxWheelSize + "\n";
        }
        return totalInformation;
    }
}

